<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class ProgressBar extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $counter = 1;
	

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "progressbar";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[progressbar title=\"Label\" status=\"60\" /]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(

		array(
			"name"		=> "status",
			"hint"		=> "0-100"
		),

		array(
			"name"		=> "title",
			"hint"		=> "title of the progress bar"
		),
		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin default"
		),

		array(
			"name"		=> "holder",
			"hint"		=> "#hexcode, default: skin default"
		),

		array(
			"name"		=> "bar",
			"hint"		=> "#hexcode, default: skin default"
		),

		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),
	
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$vars			= $data["vars"];
		$css			= array();
		$style			= array();
		$attr			= array();
		$style_holder	= array();
		$style_status	= array();
		$style_title	= array();


		if ($vars["holder"]) {
			$style_holder[] = $this->getBackground($vars["holder"] , "background")["bg_style"];
		}

		if ($vars["bar"]) {
			$style_status[] = $this->getBackground($vars["bar"] , "background")["bg_style"];
		}

		if ($vars["color"]) {
			$style_title[] = $this->getBackground($vars["color"] , "color")["bg_style"];
		}


		$info = array(
			"_title"			=> $vars["title"] ? $this->tpl->blockReplace(
				"Title" , 
				array(
					"title"			=> $vars["title"],
					"style_title"	=> implode(" " , $style_title),
				)
			) : "",
			"perc"				=> min($vars["status"], 100),
			"css"				=> $vars["class"],
			"style"				=> implode(" " , $style),
			"style_holder"		=> implode(" " , $style_holder),
			"style_status"		=> implode(" " , $style_status),
			"bg:scheme"			=> "nc",
		);


		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				$info
			),
			"before"	=> "",
			"after"		=> "",
		);

	}
	
	
}